function bindInfoWindow(marker, map, infoWindow, html) {
	google.maps.event.addListener(marker, 'click', function() {
		infoWindow.setContent(html);
		infoWindow.open(map, marker);
	});
}

function f_gen(map, template_url, infoWindow, markers, b, permalink) {

	return function(results, status) {
		if (status == google.maps.GeocoderStatus.OK) {
			var point = results[0].geometry.location;
			var html = "<b>" + results[0].formatted_address + "</b> <br/> " +
				"<a href ='"+ permalink +"'>View related post</a> <br/> ";
			var marker = new google.maps.Marker({
				map: map,
				position: point,
				icon: template_url + "/images/gmap/map_marker-blue.png"
			});
			bindInfoWindow(marker, map, infoWindow, html);
			f_gen.m++;

			if (markers.length > 1) {
				b.extend(point);
				if (f_gen.m == markers.length) {
					map.fitBounds(b);
				}
			} else {
				map.setZoom(14);
				map.setCenter(point);
			}
		}
	};

}

function load(downloadFile,instance) {
	var mapOptions = {
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};
	
	var map = new google.maps.Map(document.getElementById(instance), mapOptions);
	var infoWindow = new google.maps.InfoWindow;

	downloadUrl(downloadFile, function(data) {
	    var xml = data.responseXML;
	
		if(xml == null) {
			$('#'+instance).attr('style','padding:20px;');
			$('#'+instance).html('Sorry, no locations found.');
		} else {
		    var markers = xml.documentElement.getElementsByTagName("marker");
			geocoder = new google.maps.Geocoder();
			var b = new google.maps.LatLngBounds();
			f_gen.m = 0;

			for (var i = 0; i < markers.length; i++) {
				var address = markers[i].getAttribute("address");

				geocoder.geocode( {'address': address }, f_gen(
						map,
						template_url,
						infoWindow,
						markers,
						b,
						markers[i].getAttribute("permalink")
					)
				);
			}
		}
	});
}

function downloadUrl(url, callback) {
  var request = window.ActiveXObject ?
      new ActiveXObject('Microsoft.XMLHTTP') :
      new XMLHttpRequest;

  request.onreadystatechange = function() {
    if (request.readyState == 4) {
      request.onreadystatechange = doNothing;
      callback(request, request.status);
    }
  };

  request.open('GET', url, true);
  request.send(null);
}
function doNothing() {}

function exp_render_gmap(address,instance) {
	geocoder = new google.maps.Geocoder();
	geocoder.geocode( { 'address': address}, function(results, status) {
		if (status == google.maps.GeocoderStatus.OK) {
			var mapOptions = {
				zoom: 14,
				center: results[0].geometry.location,
				mapTypeId: google.maps.MapTypeId.ROADMAP
			};
			map = new google.maps.Map(document.getElementById(instance), mapOptions);
		 	var infoWindow = new google.maps.InfoWindow;
			var html = "<b>Current location:</b> <br/>" + address;
			var marker = new google.maps.Marker({
				map: map,
				position: results[0].geometry.location,
				icon: template_url + "/images/gmap/map_marker-blue.png"
			});
			bindInfoWindow(marker, map, infoWindow, html);
		} else {
			$('#'+instance).attr('style','padding:20px;');
			$('#'+instance).html('Sorry, location not found.');
		}
	});	   
}
